﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Test_Average
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda Average() akceptuje argument w postaci tablicy typ int
        // i zwraca średnią wartość elementów znajdujących się w tablicy. 
        private double Average(int[] iArray)
        {
            int total = 0;   // Zmienna akumulatora zainicjalizowana z wartością 0.
            double average;  // Zmienna przechowująca wartość średnią elementów tablicy.

            // Iteracja przez tablicę i dodanie do akumulatora 
            // wartości poszczególnych elementów. 
            for (int index = 0; index < iArray.Length; index++)
            {
                total += iArray[index];
            }

            // Obliczenie wartości średniej. 
            average = (double)total / iArray.Length;

            // Zwrot wartości średniej. 
            return average;
        }

        // Metoda Highest() akceptuje argument w postaci tablicy typ int 
        // i zwraca największą wartość w tej tablicy. 
        private int Highest(int[] iArray)
        {
            // Zadeklarowanie zmiennej przechowującej największą wartość 
            // i zainicjalizowanie jej z wartością pierwszego elementu tablicy. 
            int highest = iArray[0];

            // Iteracja przez pozostałą część tablicy, począwszy od 
            // elementu o indeksie 1. Gdy zostanie znaleziona większa wartość,
            // należy ją przypisać zmiennej highest. 
            for (int index = 1; index < iArray.Length; index++)
            {
                if (iArray[index] > highest)
                {
                    highest = iArray[index];
                }
            }

            // Zwrot największej wartości. 
            return highest;
        }

        // Metoda Lowest() akceptuje argument w postaci tablicy typ int 
        // i zwraca najmniejszą wartość w tej tablicy. 
        private int Lowest(int[] iArray)
        {
            // Zadeklarowanie zmiennej przechowującej najmniejszą wartość 
            // i zainicjalizowanie jej z wartością pierwszego elementu tablicy. 
            int lowest = iArray[0];

            // Iteracja przez pozostałą część tablicy, począwszy od 
            // elementu o indeksie 1. Gdy zostanie znaleziona mniejsza wartość,
            // należy ją przypisać zmiennej lowest. 
            for (int index = 1; index < iArray.Length; index++)
            {
                if (iArray[index] < lowest)
                {
                    lowest = iArray[index];
                }
            }

            // Zwrot najmniejszej wartości. 
            return lowest;
        }

        private void getScoresButton_Click(object sender, EventArgs e)
        {
            try
            {
                // Zmienne lokalne. 
                const int SIZE = 5;           // Liczba sprawdzianów. 
                int[] scores = new int[SIZE]; // Tablica wyników ze sprawdzianów.
                int index = 0;                // Licznik pętli. 
                int highestScore;             // Zmienna przechowująca najwyższy wynik.
                int lowestScore;              // Zmienna przechowująca najniższy wynik.
                double averageScore;          // Zmienna przechowująca średni wynik.
                StreamReader inputFile;       // Obiekt powiązany z plikiem. 

                // Otworzenie pliku i pobranie obiektu typu StreamReader. 
                inputFile = File.OpenText("TestScores.txt");

                // Odczytanie wyników i umieszczenie ich w tablicy. 
                while (!inputFile.EndOfStream && index < scores.Length)
                {
                    scores[index] = int.Parse(inputFile.ReadLine());
                    index++;
                }

                // Zamknięcie pliku. 
                inputFile.Close();

                // Wyświetlenie wyników ze sprawdzianów. 
                foreach (int value in scores)
                {
                    testScoresListBox.Items.Add(value);
                }

                // Pobranie wyniku najwyższego, najniższego i średniego. 
                highestScore = Highest(scores);
                lowestScore = Lowest(scores);
                averageScore = Average(scores);

                // Wyświetlenie pobranych wartości. 
                highScoreLabel.Text = highestScore.ToString();
                lowScoreLabel.Text = lowestScore.ToString();
                averageScoreLabel.Text = averageScore.ToString("n1");
            }
            catch (Exception ex)
            {
                // Wyświetlenie komunikatu błędu. 
                MessageBox.Show(ex.Message);
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
